document.addEventListener("DOMContentLoaded", function() {
// Parameters
var div = document.querySelector(".emm-container");
var defaultRdir = 'https://rdir.de/form.action';
var defaultEMail = [{ label: 'EMail', name: 'EMAIL', ph: 'Your email address', value: '', type: 'EMAIL' }];

// Functions
function setAttributes(el, attrs) {
	for(var key in attrs) {
		el.setAttribute(key, attrs[key]);
	}
}

function createInputField(name, ph, val, typ) {
	var input = document.createElement("input");
	input.type = typ;
	input.name = name;
	input.id = name;
	input.value = val;
	if(typ != 'hidden') {
		input.placeholder = ph;
	}
	return input;
}

function createOption(value, name) {
	var lbl = document.createElement('option');
	lbl.setAttribute('value', value);
	lbl.textContent = name;
	return lbl;
}

function createInputLabel(name, label) {
	var lbl = document.createElement('label');
	lbl.setAttribute('for', name);
	lbl.textContent = label;
	return lbl;
}

function getURLParameter(param, url = window.location.href) {
	var params = new URLSearchParams(url.split("?")[1]);
	return params.get(param);
}

//Create and append submit button
function createSubmitButton(form, text) {
	var submitButton = document.createElement('button');
	submitButton.setAttribute('type', 'submit');
	var submitButtonText = typeof text !== 'undefined' ? text ? text : 'Submit' : console.log('text undefined');
	submitButton.textContent = text;

	form.appendChild(submitButton);
}

//Create input with URL parameter
function createInputFromURLParam(paramName, ph, type) {
	var urlInputElem = '';
	var uidrequest = getURLParameter(paramName);
	if(uidrequest) {
		urlInputElem = createInputField(paramName, ph, uidrequest, type);
	}
	return urlInputElem;
}

//Create and append multiple inputs to form from value list
function createInputs(form, values) {
	for (let i = 0; i < values.length; i++) {
		var container = document.createElement('div');
		values[i].type == 'checkbox' || values[i].type == 'radio' ? container.classList.add("flexrow") : container.classList.add("flexcol");

		if (values[i].type !== 'hidden' && values[i].label !== 'no') {
			var inputLabel = createInputLabel(values[i].name, values[i].label);
			container.appendChild(inputLabel);
		}
		var inputElem = createInputFromURLParam(values[i].name, values[i].ph, values[i].type);
		if (inputElem == '') {
			var inputElem = createInputField(values[i].name, values[i].ph, values[i].value, values[i].type);
		}
		container.appendChild(inputElem);

		form.appendChild(container);
	}
}

//Create and append dropdown to form from value list
function createDropdown(form, labelName, name, values) {
	var dropdownLabel = createInputLabel(name, labelName);
	form.appendChild(dropdownLabel);

	var selectElem = document.createElement('select');
	setAttributes(selectElem, {'name': name, 'id': name});
	form.appendChild(selectElem);

	for (let i = 0; i < values.length; i++) {
		var opt = createOption(values[i].value, values[i].name);
		selectElem.appendChild(opt);
	}
}

// Create form element
function createForm(rdirUrl) {
	var actionUrl = '';
	typeof rdirUrl !== 'undefined' ? rdirUrl ? actionUrl = rdirUrl : actionUrl = defaultRdir : console.log('rdirUrl undefined');
	var form = document.createElement('form');
	setAttributes(form, {'id': 'emm_subscribe', 'action': actionUrl, 'method': 'POST'});

	return form;
}

//Generate final form
var form = '';
//check if not undefined ? check if not empty ? is not empty or undefined : is empty : is undefined
typeof rdirUrl !== 'undefined' ? rdirUrl ? form = createForm(rdirUrl) : console.log('rdirUrl empty') : form = createForm(defaultRdir);
if (typeof form !== 'undefined') {
	if (form) {
		form.append(createInputFromURLParam('agnUID', '', 'hidden'));
		typeof hidden_data !== 'undefined' ? hidden_data ? createInputs(form, hidden_data) : console.log('hidden_data empty') : alert('hidden_data undefined! form wonÂ´t work.');
		typeof gender !== 'undefined' ? gender ? createDropdown(form, 'Anrede', 'GENDER', gender) : console.log('gender empty') : createInputs(form, [{ label: 'Gender', name: 'GENDER', value: '2', type: 'hidden' }]);
		typeof visual_data !== 'undefined' ? visual_data ? createInputs(form, visual_data) : createInputs(form, defaultEMail) : createInputs(form, defaultEMail);
		typeof submitButtonText !== 'undefined' ? submitButtonText ? createSubmitButton(form, submitButtonText) : alert('submitButtonText empty') : createSubmitButton(form, 'submit');
	} else {console.log('form empty')}
} else {console.log('form undefined')}

div.append(form);
});
